\name{#PKGNAME#DATA}
\alias{#PKGNAME#DATA}
\title{Maps #ORGANISM# HomoloGeneIDs to homology data of other organisms
  that have homology relationships with genes represented by the HomoloGeneIDs
}
\description{
  Genes that share an arbitrary threshold level of similarity determined
  by alignment of matching bases are termed
  homologous. homologyDATA contains mappings between #ORGANISM# internal 
  HomoloGeneIDs (used by NCBI to represent sequences of an organism)
  and the data concerning genes in other organisms that have been
  identified to have homology relationships with genes represented by
  the HomoloGeneIDs  
}
\details{
  homologyDATA is an environment object with key and value pairs.
  Keys are HomoloGeneIDs and values are lists of sublists for other
  organisms that have been identified to have homology 
  relationships with the genes represented by the HomoloGeneIDs. The
  list for a given internal HomoloGeneID may have one to many sublists
  depending on whether homology relationships have been
  identified in only one or more other organisms.

  A sublist has the following elements:

  homoOrg - a named vector of a single character string whose value is
  the scientific name of the organism and name the numeric code used by
  NCBI for the organism.

  homoHGID - an integer for internal HomoloGeneID.

  homoType - a single letter for the type of similarity measurement
  between the homologous genes. homoType can be either B (reciprocal
  best best between three or more organisms), b (reciprocal best match
  between two organisms), or c (curated homology relationship between
  two organisms).

  homoPS - a percentage value measured as the percent of identity of
  base pair alignment between the homologous sequences. 

  homoURL - a url to the source if the homology relationship is a curated
  orthology.

  HomoData objects with homoType = B or b will not have any
  value for homoURL and objects with homoType = c will not have any
  value for homoPS. 

  The value of a given slot of a homoData object can be accessed by
  using homoOrg(xxx) for the homoOrg slot of the homoData object xxx,
  for example.  

  Mappings contained in homologyDATA were based on data provided
  by HomoloGene.
  
  #HGSOURCE#

  Packagebuilt #DATE#
}
\references{
\url{ftp://ftp.ncbi.nih.gov/pub/HomoloGene/hmlg.ftp}
}
\examples{
    require("annotate") || stop("annotate unavailable")
    # Convert homologyDATA to a list
    xx <- as.list(#PKGNAME#DATA)

    if(length(xx) > 0){
        # Gets the homology data for the first key of #PKGNAME#DATA
        homodata <- xx[[1]]
        # Gets the organism name, LocusLink id, internal HomoloGene id,
        # GenBank accession number, type of similarity, percent
        # similarity, and URL for percent similarity for the first
        # homoData object in the list obtained previously
        homodata[[1]][["homoOrg"]]
        homodata[[1]][["homoHGID"]]
        homodata[[1]][["homoType"]]
        homodata[[1]][["homoPS"]]
        homodata[[1]][["homoURL"]]
        # Gets the values for more than one keys
        xx[1:3]
    }
}
\keyword{datasets}

