\name{GOMFOFFSPRING}
\alias{GOMFOFFSPRING}
\title{Annotation of GO identifiers by the GO identifiers of their
  offspring} 
\description{
This is an R environment (hash table) mapping GO ids to all the GO
ids of their offspring under molecular function (MF). Offspring are
defined as the direct or indirect children/grand children nodes of a
given node for a GO id based on the directed acyclic graph defined by
Gene Ontology Consortium. GO terms for offspring nodes are more specific 
}
\details{
  GO ids are keys and the corresponding offspring GO ids are
  values. Values are vectors of GO ids for all the offspring of the key
  GO id. GO ids that do not have any offspring node are assigned NA as
  the values.  

  Molecular function is defined as the tasks performed by individual
  gene products; examples are transcription factor and DNA helicase as
  defined by Gene Ontology Consortium.  
  
  Mappings were based on data provided by:

  #GOSOURCE#

  Package built: #DATE#
}
\references{
\url{http://www.geneontology.org/} and
\url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
  require("GO", character.only = TRUE) || stop("GO unavailable")
  # Convert the environment object to a list
  xx <- as.list(GOMFOFFSPRING)
  # Remove GO ids that do not have any offspring
  xx <- xx[!is.na(xx)]
  if(length(xx) > 0){
    # Get the offspring GO ids for the first two elents of xx
  goids <- xx[1:2]
  }
}
\keyword{datasets}

