### Name: mclust1Dplot
### Title: Plot one-dimensional data modelled by an MVN mixture.
### Aliases: mclust1Dplot
### Keywords: cluster

### ** Examples

n <- 250 ## create artificial data
set.seed(0)
y <- c(rnorm(n,-5), rnorm(n,0), rnorm(n,5))
yclass <- c(rep(1,n), rep(2,n), rep(3,n))

yEMclust <- summary(EMclust(y),y)

mclust1Dplot(y, identify = TRUE, truth = yclass, z = yEMclust$z, ask=FALSE,
             mu = yEMclust$mu, sigma = yEMclust$sigma, pro = yEMclust$pro)

do.call("mclust1Dplot",
        c(list(data = y, identify = TRUE, truth = yclass, ask=FALSE), 
        yEMclust))



