### Name: density
### Title: Kernel Density Estimation
### Aliases: density print.density
### Keywords: cluster distribution smooth

### ** Examples

plot(density(c(-20,rep(0,98),20)), xlim = c(-4,4))# IQR = 0

# The Old Faithful geyser data
data(faithful)
d <- density(faithful$eruptions, bw = "sj")
d
plot(d)
dmc <- density(faithful$eruptions, method="mclust")
plot(dmc, type = "n")
polygon(dmc, col = "wheat")
lines(d, col="red")

## Missing values:
x <- xx <- faithful$eruptions
x[i.out <- sample(length(x), 10)] <- NA
doRmc <- density(x=x, method="mclust", na.rm = TRUE)
lines(doRmc, col="blue")
doR <- density(x, bw = 0.15, na.rm = TRUE)
lines(doR, col = "green")
rug(x)
points(xx[i.out], rep(0.01, 10))

## function formals returns something different now the original
## density function is masked...
base.density <- if(exists("density", envir = NULL)) {
  get("density", envir = NULL)
} else if (methods::existsFunction("density.default",
                                  where = asNamespace("stats")))
           stats::density.default else stats::density

(kernels <- eval(formals(base.density)$kernel))

## show the kernels in the R parametrization
plot (density(0, bw = 1), xlab = "",
      main="R's density() kernels with bw = 1")
for(i in 2:length(kernels))
   lines(density(0, bw = 1, kern =  kernels[i]), col = i)
legend(1.5,.4, legend = kernels, col = seq(kernels),
       lty = 1, cex = .8, y.int = 1)

data(precip)
bw <- bw.SJ(precip) ## sensible automatic choice
plot(density(precip, bw = bw, n = 2^13))
lines(density(precip, G=2:5, method="mclust"), col="red")
rug(precip)



