### Name: matchDNAPattern
### Title: Generic to find all matches of a pattern in a DNA string
### Aliases: matchDNAPattern matchDNAPattern,character,ANY-method
###   matchDNAPattern,ANY,character-method
### Keywords: classes

### ** Examples

x <- DNAString("AAGCGCGATATG")
m1 <- matchDNAPattern("GCNNNAT", x)
m1
as.matrix(m1)
m2 <- matchDNAPattern("GCNNNAT", x, algorithm="forward-search")
m2
as.matrix(m2)
data('yeastSEQCHR1')
yeast1 <- DNAString(yeastSEQCHR1)
PpiI <- "GAACNNNNNCTC" # a restriction enzyme pattern
match1.PpiI <- matchDNAPattern(PpiI, yeast1)
match2.PpiI <- matchDNAPattern(PpiI, yeast1, algorithm="forward-search")
match1.PpiI
match2.PpiI
match3.PpiI <- matchDNAPattern(PpiI, yeast1, mismatch=1)
match3.PpiI



