### Name: spotgrid
### Title: Gridding for Blocks of Microarray Spots
### Aliases: spotgrid
### Keywords: manip robust

### ** Examples

data(spotSegTest)

# columns of spotSegTest:
#  1 intensities from the Cy3 (green) channel
#  2 intensities from the Cy5 (red) channel

dataTransformation <- function(x) (256*256-1-x)^2*4.71542407E-05 

chan1 <- matrix(dataTransformation(spotSegTest[,1]), 144, 199)
chan2 <- matrix(dataTransformation(spotSegTest[,2]), 144, 199)

Grid <- spotgrid( chan1, chan2, rows = 4, cols = 6, show = TRUE)



