### Name: consensus
### Title: Build consensus tree out of bootstrap cluster result
### Aliases: consensus
### Keywords: cluster

### ** Examples

# load data
data(abf1)
## Not run: 
##D # fit the anova model
##D fit.fix = fitmaanova(abf1,formula = ~Strain)
##D # test Strain effect 
##D test.fix = matest(abf1, fit.fix, term="Strain",n.perm= 1000)
##D # pick significant genes - pick the genes selected by Fs test
##D idx <- volcano(test.fix)$idx.Fs
##D # do k-means cluster on genes
##D gene.cluster <- macluster(fit.fix, term="Strain", idx, what="gene", 
##D    method="kmean", kmean.ngroups=5, n.perm=100)
##D # get the consensus group
##D genegroup = consensus(gene.cluster, 0.5)
##D # get the gene names belonging to each group
##D genegroupname = genegroup$groupname
##D 
##D # HC cluster on samples
##D sample.cluster <- macluster(fit.fix, term="Strain", idx, what="sample",method="hc")
##D # get the consensus group
##D consensus(sample.cluster, 0.5)
## End(Not run)


