### Name: plotMDS
### Title: Multidimensional scaling plot of microarray data
### Aliases: plotMDS
### Keywords: hplot

### ** Examples

# Simulate gene expression data for 1000 probes and 6 microarrays.
# Samples are in two groups
# First 50 probes are differentially expressed in second group
sd <- 0.3*sqrt(4/rchisq(1000,df=4))
x <- matrix(rnorm(1000*6,sd=sd),1000,6)
rownames(x) <- paste("Gene",1:1000)
x[1:50,4:6] <- x[1:50,4:6] + 2
# without labels, indexes of samples are plotted.
plotMDS(x,  col=c(rep("black",3), rep("red",3)) )
# with labels as groups, group indicators are plotted.
plotMDS(x,  col=c(rep("black",3), rep("red",3)), labels= c(rep("Grp1",3), rep("Grp2",3)))



