/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.util;

import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import org.systemsbiology.gaggle.core.Boss;

public class MiscUtil {
    public static void placeInCenter(JFrame frame) {
        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
        int screenHeight = (int)gc.getBounds().getHeight();
        int screenWidth = (int)gc.getBounds().getWidth();
        int windowWidth = frame.getWidth();
        int windowHeight = frame.getHeight();
        frame.setLocation((screenWidth - windowWidth) / 2, (screenHeight - windowHeight) / 2);
    }

    public static void displayWebPage(String urlString) {
        try {
            URL url = new URL(urlString);
            MiscUtil.displayWebPage(url);
        }
        catch (Exception ex0) {
            ex0.printStackTrace();
        }
    }

    public static void displayWebPage(URL url) {
        try {
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            bs.showDocument(url);
            System.out.println("BasicService url: " + url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MiscUtil.openURL(url.toString());
        }
    }

    public static String getPage(String urlString) throws Exception {
        return MiscUtil.getPage(new URL(urlString));
    }

    public static void setApplicationIcon(JFrame frame) {
        try {
            frame.setIconImage(Toolkit.getDefaultToolkit().getImage(new URL("http://gaggle.systemsbiology.net/images/icons/gaggle_icon_32x32.gif")));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static String getPage(URL url) throws Exception {
        String thisLine;
        boolean characterCount = false;
        StringBuffer result = new StringBuffer();
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        int responseCode = urlConnection.getResponseCode();
        String contentType = urlConnection.getContentType();
        int contentLength = urlConnection.getContentLength();
        String contentEncoding = urlConnection.getContentEncoding();
        if (responseCode != 200) {
            throw new IOException("\nHTTP response code: " + responseCode);
        }
        BufferedReader theHTML = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        while ((thisLine = theHTML.readLine()) != null) {
            result.append(thisLine);
            result.append(" ");
        }
        return result.toString();
    }

    public static void openURL(String url) {
        String UNIX_PROTOCOL = "file:";
        String UNIX_PATH = "gnome-moz-remote";
        String UNIX_FLAG = "-remote openURL";
        String WINDOWS_PATH = "cmd.exe /c start";
        String MAC_PATH = "open";
        String osName = System.getProperty("os.name");
        try {
            String cmd = osName.startsWith("Windows") ? WINDOWS_PATH + " " + url : (osName.startsWith("Mac") ? MAC_PATH + " " + url : UNIX_PATH + " " + url);
            Process p = Runtime.getRuntime().exec(cmd);
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    cmd = UNIX_PATH + " " + url;
                    p = Runtime.getRuntime().exec(cmd);
                }
            }
            catch (InterruptedException ex) {}
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public static void setJFrameAlwaysOnTop(JFrame frame, boolean newValue) {
        frame.setAlwaysOnTop(newValue);
    }

    public static void updateGooseChooserOLD(Boss boss, JComboBox chooser, String callingGoose, String[] pseudoGeese) {
        try {
            int i;
            DefaultComboBoxModel model = (DefaultComboBoxModel)chooser.getModel();
            model.removeAllElements();
            if (boss == null) {
                model.addElement("Not Connected to Boss");
                return;
            }
            model.addElement("Boss");
            String[] geese = null;
            try {
                geese = boss.getGooseNames();
            }
            catch (Exception e) {
                model.removeAllElements();
                model.addElement("Couldn't connect to Boss");
                throw e;
            }
            ArrayList<String> tmp = new ArrayList<String>();
            for (i = 0; i < geese.length; ++i) {
                tmp.add(geese[i]);
            }
            if (pseudoGeese != null && pseudoGeese.length > 0) {
                for (i = 0; i < pseudoGeese.length; ++i) {
                    tmp.add(pseudoGeese[i]);
                }
            }
            Object[] allGeese = tmp.toArray(new String[0]);
            Arrays.sort(allGeese);
            for (int i2 = 0; i2 < allGeese.length; ++i2) {
                if (((String)allGeese[i2]).equals(callingGoose)) continue;
                model.addElement(allGeese[i2]);
            }
        }
        catch (Exception ex0) {
            ex0.printStackTrace();
        }
    }

    public static void updateGooseChooser(JComboBox gooseChooser, String callingGoose, String[] allGeese) {
        if (gooseChooser == null || allGeese == null) {
            return;
        }
        String savedItem = (String)gooseChooser.getSelectedItem();
        Arrays.sort(allGeese);
        DefaultComboBoxModel model = (DefaultComboBoxModel)gooseChooser.getModel();
        model.removeAllElements();
        model.addElement("Boss");
        for (String gooseName : allGeese) {
            if (gooseName.equals(callingGoose)) continue;
            model.addElement(gooseName);
        }
        gooseChooser.setSelectedItem(savedItem);
    }

    public static int countOccurences(String textToSearch, String pattern) {
        int base = 0;
        int count = 0;
        boolean done = false;
        while (!done) {
            if ((base = textToSearch.indexOf(pattern, base)) > 0) {
                ++count;
                base += 3;
                continue;
            }
            done = true;
        }
        return count;
    }
}

