### Name: thresholds-class
### Title: thresholds: A class to handle the thresholds to be tested during
###   training of the Nearest Shrunken Centroid
### Aliases: thresholds-class getNoThresholds,thresholds-method
###   getNoThresholds<-,thresholds-method getNoThresholds getNoThresholds<-
###   getOptionValues,thresholds-method getOptionValues<-,thresholds-method
###   getOptionValues getOptionValues<-
### Keywords: classes

### ** Examples

# Empty thresholds, the default values will be used when added to an assessment
emptThresholds <- new("thresholds")
getOptionValues(emptThresholds)
getNoThresholds(emptThresholds)

# Another thresholds
thresholds <- new("thresholds", optionValues=c(0,0.1,0.2,1,2))
getOptionValues(thresholds)
getNoThresholds(thresholds)

# Set the thresholds
newThresholds <- c(0.1,0.2,0.5,0.6,1)
getOptionValues(thresholds) <- newThresholds
getOptionValues(thresholds)
getNoThresholds(thresholds)



