mxy.abs.plot              package:OLIN              R Documentation

_G_e_n_e_r_a_t_i_o_n _o_f _M_X_Y _p_l_o_t_s _o_f _a_b_s_o_l_u_t_e _v_a_l_u_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     This function produce a MXY plot of absolute values of M including
     a colour bar.

_U_s_a_g_e:

     mxy.abs.plot(V,Ngc,Ngr,Nsc,Nsr,color.lim,color="red",xlab="Columns",ylab="Rows",...) 

_A_r_g_u_m_e_n_t_s:

       V: vector of positive values

     Ngc: number of columns for the grid matrix

     Ngr: number of rows for the grid matrix

     Nsc: number of columns for the spot matrix

     Nsr: number of rows for the spot matrix

color.lim: limits of color range for MXY plot

   color: color to be used for plot: red (default) or green

    xlab: label of x -axis of MXY plot

    ylab: label of y-axis of MXY plot

     ...: Further optional graphical parameter for the 'image' function
          generating the MXY plot

_D_e_t_a_i_l_s:

     The function 'mxy.abs.plot' is similar to function 'mxy.plot'.
     Details can therefore be found at 'mxy.plot'. Two differences,
     however, exist: First, 'mxy.abs.plot'  plots the absolute value of
     V and second,  red (default) or green can be chosen as  colour
     of plotting. Hence,  'mxy.abs.plot' facilitates  the inspection of
      spatial artifacts in single fluorescence channels.

_A_u_t_h_o_r(_s):

     Matthias E. Futschik (<URL:
     http://itb.biologie.hu-berlin.de/~futschik>)

_S_e_e _A_l_s_o:

     'v2m', 'm2v', 'colorbar.mxy.abs', 'fgbg.visu', 'image'

_E_x_a_m_p_l_e_s:

     # LOADING DATA
     data(sw)
     # PLOTTING OF ABSOLUTE LOGGED FOLD-CHANGES
     mxy.plot(abs(maM(sw)[,1]),Ngc=maNgc(sw),Ngr=maNgr(sw),Nsc=maNsc(sw),Nsr=maNsr(sw))

     # PLOTTING SPATIAL DISTRIBUTION OF SINGLE-CHANNEL INTENSITIES
     mxy.abs.plot(maRf(sw)[,1],color.lim=c(0,10000),Ngc=maNgc(sw),Ngr=maNgr(sw),
                  Nsc=maNsc(sw),Nsr=maNsr(sw))
     mxy.abs.plot(maGf(sw)[,1],color.lim=c(0,10000),color="green",Ngc=maNgc(sw),Ngr=maNgr(sw),
                  Nsc=maNsc(sw),Nsr=maNsr(sw))

