### Name: calculateLpeAdj
### Title: Evaluates local pooled error significance test with user chosen
###   variance adjustments.
### Aliases: calculateLpeAdj
### Keywords: methods

### ** Examples

   
 # Loading the library and the data
 library(LPEadj)
 data(Ley)

 ADJ.VALUES <- c(1, 1, 1.34585905516761 ,1.19363228146169 ,1.436849413109
                  ,1.289652132873 ,1.47658053092781 ,1.34382984852146
                  ,1.49972130857404, 1.3835405678718)
            
 dim(Ley)
 # Gives 12488*7 
 # First column is ID.


 # Subsetting the data
 subset.Ley <- Ley[1:1000,]
  
 subset.Ley[,2:7] <- preprocess(subset.Ley[,2:7],data.type="MAS5")
  
 # Finding the baseline distribution of condition 1 and 2.
 var.1 <- adjBaseOlig.error(subset.Ley[,2:4], q=0.01, setMax1=FALSE)
 var.2 <- adjBaseOlig.error(subset.Ley[,5:7], q=0.01, setMax1=FALSE)
 
 # Applying LPE
 lpe.result <- calculateLpeAdj(subset.Ley[,2:4],subset.Ley[,5:7], var.1, var.2,
                probe.set.name=subset.Ley[,1], adjust1=ADJ.VALUES[3],
                adjust2=ADJ.VALUES[3])
  



