### Name: ITALICS
### Title: Affymetrix SNP chip normalization
### Aliases: ITALICS Italics italics


### ** Examples

## Not run: 
##D ## step to get the path of the HF0844_Hind.CEL file
##D ITALICSDataPATH <- attr(as.environment(match("package:ITALICSData",search())),"path")
##D filename <- paste(ITALICSDataPATH,"/data/HF0844_Hind.CEL", sep="")
##D quartetEffectFile <- paste(ITALICSDataPATH,"/data/Hind.QuartetEffect.csv", sep="")
##D 
##D ## load quartet effect
##D quartetEffect <- read.table(quartetEffectFile, sep=";", header=TRUE)
##D 
##D ## load annotation using the pd.mapping50k.xba24 or pd.mapping50k.hind240 or  pd.mapping250k.sty or pd.mapping250k.nsp package
##D headdetails <- readCelHeader(filename[1])
##D pkgname <- cleanPlatformName(headdetails[["chiptype"]])
##D snpInfo <- getSnpInfo(pkgname)
##D quartet <- getQuartet(pkgname, snpInfo)
##D 
##D ## read cel files and format data
##D tmpExprs <- readCelIntensities(filename, indices=quartet$fid)
##D quartet$quartetInfo$quartetLogRatio <- readQuartetCopyNb(tmpExprs)
##D quartet$quartetInfo <- addInfo(quartet, quartetEffect)
##D snpInfo <- fromQuartetToSnp(cIntensity="quartetLogRatio", quartetInfo=quartet$quartetInfo, snpInfo=snpInfo)
##D 
##D ## ITALICS normalization
##D profilSNPHind <- ITALICS(quartet$quartetInfo, snpInfo,
##D     formule="Smoothing+QuartetEffect+FL+I(FL^2)+I(FL^3)+GC+I(GC^2)+I(GC^3)")
##D 
##D ## plot the profile
##D plotProfile(profilSNPHind, Smoothing="Smoothing", Bkp=TRUE)
## End(Not run)



