### Name: GSsave.exp
### Title: Save a GeneSpring Interpretation to file
### Aliases: GSsave.exp
### Keywords: IO

### ** Examples

#Use the example data etc. from ExpressionSet
library(Biobase)
data(geneData)
data(geneCov)
covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
names(covdesc) <- names(geneCov)
pdata <- new("AnnotatedDataFrame")
pData(pdata) <- geneCov
varLabels(pdata) <- covdesc
eset <- new("ExpressionSet", exprs=geneData, phenoData=pdata)

#Convert the objects into GeneSpring objects
gs.int <- BC2GSint(eset)

#Save the Experiment in GeneSpring format
GSsave.exp(gs.int, filename = "GS_R_out.txt")



