### Name: gwSnpTests
### Title: methods for iterating association tests (expression vs SNP)
###   across genomes or chromosomes
### Aliases: gwSnpTests residTests
###   residTests,cwSnpScreenResult,smlSet,formula,missing-method chunksize
###   chunksize-class gwSnpTests,formula,smlSet,cnumOrMissing-method
###   gwSnpTests,formula,smlSet,cnumOrMissing,ANY-method
###   gwSnpTests,formula,smlSet,snpdepth-method
###   gwSnpTests,formula,smlSet,snpdepth,ANY-method
###   gwSnpTests,formula,smlSet,snpdepth,chunksize-method
### Keywords: models

### ** Examples

if (!exists("hmceuB36.2021")) data(hmceuB36.2021)
# condense to founders only
hmFou = hmceuB36.2021[, which(hmceuB36.2021$isFounder)]
# show basic formula fit
f1 = gwSnpTests(genesym("CPNE1")~male, hmFou, chrnum(20))
f1
plot(f1)
# show how to avoid adjusted fit
f1b = gwSnpTests(genesym("CPNE1")~1-1, hmFou, chrnum(20))
# show gene set modeling on chromosome
library(GSEABase)
gs1 = GeneSet(c("CPNE1", "ADA"))
geneIdType(gs1) = SymbolIdentifier()
f2 = gwSnpTests(gs1~male, hmFou, chrnum(20))
f2
names(f2)
plot(f2[["ADA"]])
# show 'smlSet-wide' fit
f3 = gwSnpTests(gs1~male, hmFou)
f3
# now use a phenoVar
f3b = gwSnpTests(phenoVar("persid")~male, hmFou, chrnum(20))
topSnps(f3b)
## Not run: 
##D # in example() we run into a problem with sys.call(2); works
##D # in interpreter
##D f4 = gwSnpTests(gs1~male, hmFou, snpdepth(250), chunksize(1))
##D f4
##D   
## End(Not run)



