snpLocs.Hs              package:GGBase              R Documentation

_S_N_P _l_o_c_a_t_i_o_n _a_c_c_e_s_s_o_r

_D_e_s_c_r_i_p_t_i_o_n:

     SNP location accessor

_U_s_a_g_e:

     snpLocs.Hs(cnum, rsid)

_A_r_g_u_m_e_n_t_s:

    cnum: chrnum instance indicating chromosome

    rsid: rsid instance giving dbSNP ids for snps of interest

_D_e_t_a_i_l_s:

     The SNPlocs.Hsapiens.dbSNP.* package is curated by Bioconductor
     and maintains location and allele information on SNP.

     The hsSnpLocs environment is available through data(hsSnpLocs),
     and contains a unified representation of the information in the
     SNPlocs package (which is only available through various
     chromosome-specific calls).

_V_a_l_u_e:

     two-row matrix - top row is numeric suffix of dbSNP ids, bottom
     row is location, genome-wide if chrnum is missing

_A_u_t_h_o_r(_s):

     Vince Carey <stvjc@channing.harvard.edu>

_E_x_a_m_p_l_e_s:

     library(GGtools)
     data(hmceuB36.2021)
     nn21 = colnames(smList(hmceuB36.2021)[["21"]])
     length(nn21)
     ss = snpLocs.Hs(chrnum(21), rsid(nn21))
     dim(ss)
     # notes that the locations available are not completely
     # congruent with those asserted in HapMap data

