### Name: cmp.duplicated
### Title: quickly detect compound duplication in a descriptor database
### Aliases: cmp.duplicated
### Keywords: utilities

### ** Examples

# load sample database from web
db <- cmp.parse("http://bioweb.ucr.edu/ChemMineV2/static/example_db.sdf")
# manually create a duplication
# note that we ignore the other information in the database and only consider
# the descriptor information
db$descdb[[89]] <- db$descdb[[10]]
length(db$descdb)
# find duplication
dup <- cmp.duplicated(db)
# locate duplicated compound using search
cmp.search(db, db$descdb[dup][[1]], cutoff=1, quiet=TRUE)
# remove duplication from db
db$descdb <- db$descdb[!dup]
# normally you should also clear the entries in db$cids and db$sdfsegs
length(db$descdb)



