###################################################
### chunk number 1: initialize
###################################################
options(width=70)


###################################################
### chunk number 2: rtl-init
###################################################
library("humanStemCell")
data(fhesc)
library("genefilter")
filtFhesc <- nsFilter(fhesc)[[1]]
library("limma")
design <- model.matrix(~filtFhesc$Diff) 
hesclim <- lmFit(filtFhesc, design) 
hesceb <- eBayes(hesclim) 
tab <- topTable(hesceb, coef = 2, adjust.method = "BH", n = 7676) 
tab2 <- tab[(tab$logFC > 1) & (tab$adj.P.Val < 0.01),]
affyIDs <- tab2$ID
library("microRNA")
data(hsTargets)
library("hgu133plus2.db")
entrezIDs <- mappedRkeys(hgu133plus2ENTREZID[affyIDs])
library("org.Hs.eg.db")
mappedEntrezIDs <- entrezIDs[entrezIDs %in% mappedkeys(org.Hs.egENSEMBLTRANS)]
ensemblIDs <- mappedRkeys(org.Hs.egENSEMBLTRANS[mappedEntrezIDs])
targetMatches <- match(ensemblIDs, hsTargets$target, 0)
targets <- hsTargets[targetMatches,]


###################################################
### chunk number 3: rtl-miRNA-track
###################################################
head(targets)
library(rtracklayer)
targetTrack <- trackSet(targets)


###################################################
### chunk number 4: feature-data-accessors
###################################################
head(chrom(targetTrack))
head(start(targetTrack))


###################################################
### chunk number 5: sol-1
###################################################
head(strand(targetTrack))
head(end(targetTrack) - start(targetTrack) + 1)
data.frame(chrom = chrom(targetTrack), 
           start = start(targetTrack), end = end(targetTrack),
           strand = strand(targetTrack))


###################################################
### chunk number 6: subset-features
###################################################
## get the first 10 targets
first10 <- targetTrack[1:10]
## get pos strand targets
posTargets <- targetTrack[strand(targetTrack) == "+"]


###################################################
### chunk number 7: subset-chrid
###################################################
chr1Targets <- targetTrack[chrid("chr1")]


###################################################
### chunk number 8: sol-2
###################################################
negTargetTrack <- targetTrack[strand(targetTrack) == "-"]


###################################################
### chunk number 9: export eval=FALSE
###################################################
## export(targetTrack, "targets.bed")


###################################################
### chunk number 10: import eval=FALSE
###################################################
## restoredTrack <- import("targets.bed")


###################################################
### chunk number 11: sol-3
###################################################
export(targetTrack, "targets.gff")
targetGff <- import("targets.gff")
targetChar <- export(targetTrack, format = "gff1")


###################################################
### chunk number 12: browserSession eval=FALSE
###################################################
## session <- browserSession("ucsc")


###################################################
### chunk number 13: genomeBrowsers
###################################################
genomeBrowsers()


###################################################
### chunk number 14: layTrack eval=FALSE
###################################################
## session <- layTrack(session, targetTrack, name = "targets")


###################################################
### chunk number 15: sol-4 eval=FALSE
###################################################
## session <- layTrack(session, targetTrack[1:100], name = "target100")


###################################################
### chunk number 16: genomeSegment-track
###################################################
genomeSegment(chr1Targets)


###################################################
### chunk number 17: sol-5
###################################################
segment <- genomeSegment(targetTrack[1])
chrom(segment)


###################################################
### chunk number 18: take-subset
###################################################
subTargetTrack <- targetTrack[1] # get first feature


###################################################
### chunk number 19: view-subset eval=FALSE
###################################################
## view <- browserView(session, genomeSegment(subTargetTrack) / 10, 
##                     pack = "targets")


###################################################
### chunk number 20: sol-6 eval=FALSE
###################################################
## viewOut <- browserView(session, genomeSegment(view) / 2)
## viewFull <- browserView(session, full = "targets")


###################################################
### chunk number 21: browseGenome eval=FALSE
###################################################
## browseGenome(tracks = targetTrack, 
##              segment = genomeSegment(subTargetTrack) / 10)


###################################################
### chunk number 22: browseGenome-simple eval=FALSE
###################################################
## browseGenome(subTargetTrack)


###################################################
### chunk number 23: get-track-names eval=FALSE
###################################################
## loaded_tracks <- tracks(session)


###################################################
### chunk number 24: get-track-data eval=FALSE
###################################################
## subTargetTrack <- trackSet(session, "targets")


###################################################
### chunk number 25: get-track-segment eval=FALSE
###################################################
## posTargets <- trackSet(session, "targets", genomeSegment(chr1Targets))


###################################################
### chunk number 26: sol-7 eval=FALSE
###################################################
## targetSNP <- trackSet(session, "snp128", genomeSegment(subTargetTrack))
## featureNames(targetSNP)
## targetGene <- trackSet(session, "knownGene", genomeSegment(subTargetTrack))
## featureNames(targetGene)


###################################################
### chunk number 27: genomeSegment-view eval=FALSE
###################################################
## segment <- genomeSegment(view)


###################################################
### chunk number 28: tracks-view eval=FALSE
###################################################
## visible_tracks <- tracks(view)
## tracks(view) <- visible_tracks


###################################################
### chunk number 29: track-modes-view eval=FALSE
###################################################
## modes <- ucscTrackModes(view)


###################################################
### chunk number 30: set-track-modes eval=FALSE
###################################################
## modes["targets"]
## modes["targets"] <- "full"
## ucscTrackModes(view) <- modes


###################################################
### chunk number 31: browserViews eval=FALSE
###################################################
## views <- browserViews(session)
## length(views)


###################################################
### chunk number 32: sol-8 eval=FALSE
###################################################
## viewTarget <- trackSet(session, "targets", genomeSegment(view))
## tracks(view) <- c("snp128", "knownGene", "targets")
## ucscTrackModes(view)["knownGene"] <- "hide"


###################################################
### chunk number 33: load-snp
###################################################
library(rtracklayer)
data(cpneTrack)


###################################################
### chunk number 34: datavals-accessor
###################################################
head(dataVals(cpneTrack))


###################################################
### chunk number 35: trackData
###################################################
plot(start(cpneTrack), dataVals(cpneTrack))


###################################################
### chunk number 36: layTrack-snp eval=FALSE
###################################################
## session <- browserSession()
## session <- layTrack(session, cpneTrack, name = "cpne")


###################################################
### chunk number 37: browserView-snp eval=FALSE
###################################################
## view <- browserView(session, genomeSegment(cpneTrack[1:5]), full = "cpne")


###################################################
### chunk number 38: layTrack-snp2 eval=FALSE
###################################################
## session <- layTrack(session, cpneTrack, name = "cpne2", 
##                     autoScale = FALSE,
##                     yLineOnOff = TRUE, 
##                     yLineMark = quantile(dataVals(cpneTrack), .25))
## view <- browserView(session, genomeSegment(cpneTrack[1:5]), full = "cpne2")


###################################################
### chunk number 39: search-nrsf
###################################################
library(BSgenome.Hsapiens.UCSC.hg18)
nrsfPD <- PDict("TCAGCACCATGGACAG") # TCAGCACC trusted band
nrsfHits <- matchPDict(nrsfPD, Hsapiens[[1]])
countIndex(nrsfHits)


###################################################
### chunk number 40: trackSet-nrsf
###################################################
nrsfTrack <- trackSet(unlist(nrsfHits), "chr1", "+")


###################################################
### chunk number 41: browserView-nrsf eval=FALSE
###################################################
## session <- browseGenome(nrsfTrack, segment = genomeSegment(nrsfTrack[1]) / 10)


###################################################
### chunk number 42: session-info
###################################################
  sessionInfo()


