### Name: score
### Title: Computes the marginal likelihood of phenotypic hierarchies
### Aliases: score print.score PhiDistr
### Keywords: models

### ** Examples

   # Drosophila RNAi and Microarray Data from Boutros et al, 2002
   data("BoutrosRNAi2002")
   D <- BoutrosRNAiDiscrete[,9:16]

   # enumerate all possible models for 4 genes
   models <- enumerate.models(unique(colnames(D)))

   # score models with marginal likelihood
   result <- score(models,D,type="mLL",para=c(.13,.05))
   
   # plot graph of the best model
   plot(result,what="graph")

   # plot scores
   plot(result,what="mLL") 
    
   # plot posterior of E-gene positions according to best model
   plot(result,what="pos")
   
   # MAP estimate of effect positions for the best model
   result$mappos




