### Name: loadmirnatogene
### Title: Load miRNA to gene associations for miRNApath
### Aliases: loadmirnatogene
### Keywords: IO manip attribute

### ** Examples


## Load miRNA expression data from AD miRNA paper
## This data contains miRNA expression data, 
data(mirnaobj);

## Display the state, which should generally be "unfiltered"
## at this point
mirnaobj@state;

## Display summary information about the object
mirnaobj;

## Annotate hits by filtering by P-value 0.05
mirnaobj <- filtermirnapath( mirnaobj, pvalue = 0.05,
    expression = NA, foldchange = NA );

## Write a file as example of required input
write.table(mirnaobj@mirnaGene, file = "mirnaGene.txt", 
    quote = FALSE, row.names = FALSE, col.names = TRUE, na = "",
    sep = "\t");

## Load the miRNA to gene associations
mirnaobj <- loadmirnatogene( mirnafile = "mirnaGene.txt",
    mirnaobj = mirnaobj, mirnacol = "miRNA Name",
    genecol = "Entrez Gene ID", 
    columns = c(assayidcol = "ASSAYID") );

## Display summary, noting the number of genes reported
mirnaobj;



