### Name: splom
### Title: Method implementing Lattice scatter plot matrices for flow data.
### Aliases: splom splom,flowFrame,missing-method panel.splom.flowframe
### Keywords: methods dplot

### ** Examples


data(GvHD)

tf <- transformList(colnames(GvHD)[3:7], asinh)
dat <- tf %on% GvHD[[3]]

## scatter plot matrix of individual flowFrames
lattice.options(panel.error=NULL)
splom(dat)

splom(dat[,1:3], smooth = FALSE)

## displaying filters
rg <- rectangleGate("FSC-H"=c(200,400), "SSC-H"=c(300,700),
"FL1-H"=c(2,4), "FL2-A"=c(4,7))
splom(dat, filter=rg)

splom(dat, filter=rectangleGate("FSC-H"=c(400,800)))

splom(dat[,1:4], smooth = FALSE, filter=norm2Filter("FSC-H", "SSC-H", scale=1.5))




