###################################################
### chunk number 1: prepare
###################################################
options(length=60)
set.seed(123)


###################################################
### chunk number 2: loadpackage
###################################################
library("Ringo")


###################################################
### chunk number 3: locateData
###################################################
exDir <- system.file("exData",package="Ringo")
list.files(exDir, pattern="pair.txt")
head(read.delim(file.path(exDir,"MOD_20551_PMT1_pair.txt"), skip=1))[,c(1,4:7,9)]


###################################################
### chunk number 4: exampleFilesTxt
###################################################
read.delim(file.path(exDir,"example_targets.txt"), header=TRUE) 


###################################################
### chunk number 5: spottypes
###################################################
read.delim(file.path(exDir,"spottypes.txt"), header=TRUE) 


###################################################
### chunk number 6: readNimblegen
###################################################
exRG <- readNimblegen("example_targets.txt","spottypes.txt",path=exDir)


###################################################
### chunk number 7: showRG
###################################################
head(exRG$R)
head(exRG$G)
head(exRG$genes)
exRG$targets


###################################################
### chunk number 8: loadProbeAnno
###################################################
load(file.path(exDir,"exampleProbeAnno.rda"))
ls(exProbeAnno)
show(exProbeAnno)
head(exProbeAnno["9.start"])
head(exProbeAnno["9.end"])


###################################################
### chunk number 9: imageRG0 eval=FALSE
###################################################
## par(mar=c(0.01,0.01,0.01,0.01), bg="black")
## image(exRG, 1, channel="green", mycols=c("black","green4","springgreen"))


###################################################
### chunk number 10: imageRG
###################################################
jpeg("Ringo-imageRG.jpg", quality=100, height=400, width=360)
par(mar=c(0.01,0.01,0.01,0.01), bg="black")
image(exRG, 1, channel="green", mycols=c("black","green4","springgreen"))
dev.off()


###################################################
### chunk number 11: plotDensities
###################################################
plotDensities(exRG)


###################################################
### chunk number 12: showGFF
###################################################
head(exGFF[,c("name","symbol","chr","strand","start","end")])


###################################################
### chunk number 13: autocorRG0
###################################################
exAc <- autocor(exRG, probeAnno=exProbeAnno, chrom="9", lag.max=1000)
plot(exAc)


###################################################
### chunk number 14: preprocess eval=FALSE
###################################################
## exampleX <- preprocess(exRG)
## sampleNames(exampleX) <- 
##  with(exRG$targets, paste(Cy5,"vs",Cy3,sep="_"))
## print(exampleX)


###################################################
### chunk number 15: loadExampleX
###################################################
load(file.path(exDir,"exampleX.rda"))
print(exampleX)


###################################################
### chunk number 16: preprocessNG
###################################################
exampleX.NG <- preprocess(exRG, method="nimblegen")
sampleNames(exampleX.NG) <- sampleNames(exampleX)


###################################################
### chunk number 17: comparePreprocessings
###################################################
corPlot(cbind(exprs(exampleX),exprs(exampleX.NG)),
        grouping=c("VSN normalized","Tukey-biweight scaled"))


###################################################
### chunk number 18: chipAlongChrom0 eval=FALSE
###################################################
## chipAlongChrom(exampleX, chrom="9", xlim=c(34318000,34321000), ylim=c(-2,4), probeAnno=exProbeAnno, gff=exGFF)


###################################################
### chunk number 19: chipAlongChrom
###################################################
par(mar=c(2.5,4.2,4,1.5), font.lab=2)
chipAlongChrom(exampleX, chrom="9", xlim=c(34318000,34321000), ylim=c(-2,4), probeAnno=exProbeAnno, gff=exGFF)


###################################################
### chunk number 20: smoothing
###################################################
smoothX <- computeRunningMedians(exampleX, probeAnno=exProbeAnno,
modColumn = "Cy5", allChr = "9", winHalfSize = 400)
sampleNames(smoothX) <- paste(sampleNames(exampleX),"smoothed")


###################################################
### chunk number 21: smoothAlongChrom0 eval=FALSE
###################################################
## chipAlongChrom(exampleX, chrom="9", xlim=c(34318000,34321000), ylim=c(-2,4), probeAnno=exProbeAnno, gff=exGFF)
## chipAlongChrom(smoothX, chrom="9", xlim=c(34318000,34321000), probeAnno=exProbeAnno, itype="l", ilwd=4, paletteName="Spectral", add=TRUE)


###################################################
### chunk number 22: smoothAlongChrom
###################################################
#jpeg("Ringo-smoothAlongChrom.jpg", quality=100, width=960, height=480)
par(mar=c(2.5,4.2,4,1.5), font.lab=2)
chipAlongChrom(exampleX, chrom="9", xlim=c(34318000,34321000), ylim=c(-2,4), probeAnno=exProbeAnno, gff=exGFF)
chipAlongChrom(smoothX, chrom="9", xlim=c(34318000,34321000), probeAnno=exProbeAnno, itype="l", ilwd=4, paletteName="Spectral", add=TRUE)
#dev.off()


###################################################
### chunk number 23: setY0
###################################################
(y0 <- apply(exprs(smoothX),2,upperBoundNull))


###################################################
### chunk number 24: histogramSmoothed0 eval=FALSE
###################################################
## par(font.lab=2, mar=c(4,4,1,1))
## hist(exprs(smoothX)[,1], n=25, xlab="Smoothed reporter intensities [log]", xlim=c(-2,2), main=NA, col=brewer.pal(8,"Set2")[1])
## abline(v=y0[,1], col="red")


###################################################
### chunk number 25: histogramSmoothed
###################################################
#pdf(file="Ringo-histogramSmoothed.pdf", width=7, height=5)
par(font.lab=2, mar=c(4,4,1,1))
h1 <- hist(exprs(smoothX)[,1], n=25, xlab="Smoothed reporter intensities [log]", xlim=c(-3,5), main=NA, col=brewer.pal(8,"Set2")[1])
abline(v=y0[1], col="red")
#dev.off()


###################################################
### chunk number 26: cherFinding
###################################################
chersX <- findChersOnSmoothed(smoothX, probeAnno=exProbeAnno, thresholds=y0, allChr="9", distCutOff=600, cellType="human")
chersX <- relateChers(chersX, exGFF)
chersXD <- as.data.frame.cherList(chersX)


###################################################
### chunk number 27: showChers
###################################################
chersXD[order(chersXD$maxLevel, decreasing=TRUE),]


###################################################
### chunk number 28: plotCher0 eval=FALSE
###################################################
## plot(chersX[[1]], smoothX, probeAnno=exProbeAnno, gff=exGFF, paletteName="Spectral")


###################################################
### chunk number 29: plotCher
###################################################
#jpeg("Ringo-plotCher.jpg", quality=100, width=960, height=480)
par(mar=c(2.5,4.2,4,1.5), font.lab=2)
plot(chersX[[1]], smoothX, probeAnno=exProbeAnno, gff=exGFF, paletteName="Spectral")
#dev.off()


###################################################
### chunk number 30: sessionInfo
###################################################
toLatex(sessionInfo())


