###################################################
### chunk number 1: 
###################################################
library(KCsmart)


###################################################
### chunk number 2: 
###################################################
data(hsSampleData)


###################################################
### chunk number 3: 
###################################################
str(hsSampleData)


###################################################
### chunk number 4: 
###################################################
data(hsMirrorLocs)


###################################################
### chunk number 5: 
###################################################
spm1mb <- calcSpm(hsSampleData, hsMirrorLocs)
spm4mb <- calcSpm(hsSampleData, hsMirrorLocs, sigma=4000000)


###################################################
### chunk number 6: 
###################################################
plot(spm1mb, interpolation=10)


###################################################
### chunk number 7: 
###################################################
plot(spm1mb, chromosomes=c(1, 12, "X"), type="g")


###################################################
### chunk number 8: 
###################################################
sigLevel1mb <- findSigLevelTrad(hsSampleData, spm1mb, n=3, p=0.05)


###################################################
### chunk number 9: 
###################################################
plot(spm1mb, sigLevels=sigLevel1mb, type=1, interpolation=10)


###################################################
### chunk number 10: 
###################################################
plot(spm1mb, chromosomes=c(1, 12, "X"), type="g", sigLevels=sigLevel1mb)


###################################################
### chunk number 11: 
###################################################
sigRegions1mb <- getSigSegments(spm1mb,sigLevel1mb)


###################################################
### chunk number 12: 
###################################################
sigRegions1mb


###################################################
### chunk number 13: 
###################################################
sigRegions1mb@gains[[1]]$probes


###################################################
### chunk number 14: 
###################################################
sigLevel4mb <- findSigLevelTrad(hsSampleData, spm4mb, n=3)


###################################################
### chunk number 15: 
###################################################
plotScaleSpace(list(spm1mb, spm4mb), list(sigLevel1mb, sigLevel4mb), type='g')


