### Name: Views-utils
### Title: Utility functions and numeric summary of Views of numerics
### Aliases: Views-utils slice slice,integer-method slice,XInteger-method
###   slice,XRleInteger-method viewMins viewMins,XIntegerViews-method
###   viewMins,XRleIntegerViews-method viewMaxs
###   viewMaxs,XIntegerViews-method viewMaxs,XRleIntegerViews-method
###   viewSums viewSums,XIntegerViews-method
###   viewSums,XRleIntegerViews-method
### Keywords: methods algebra arith

### ** Examples

  ## Views derived from vector
  vec <- as.integer(c(19, 5, 0, 8, 5))
  slice(vec, lower=5, upper=8)

  set.seed(0)
  vec <- sample(24)
  vecViews <- slice(vec, lower=4, upper=16)
  vecViews
  viewMins(vecViews)
  viewMaxs(vecViews)
  viewSums(vecViews)

  ## Views derived from coverage
  x <- IRanges(start=c(1L, 9L, 4L, 1L, 5L, 10L),
               width=c(5L, 6L, 3L, 4L, 3L,  3L))
  coverage(x, start=1, end=15)



