### Name: RangedData-class
### Title: Data on ranges
### Aliases: RangedData-class annotation annotation,RangedData-method
###   dim,RangedData-method dimnames,RangedData-method
###   end,RangedData-method length,RangedData-method
###   names,RangedData-method names<-,RangedData-method ranges
###   ranges,RangedData-method start,RangedData-method values
###   values,RangedData-method width,RangedData-method RangedData
###   as.data.frame,RangedData-method coerce,RangedData,XDataFrame-method
###   coerce,XRle,RangedData-method c,RangedData-method
###   split,RangedData-method [,RangedData,ANY,ANY,ANY-method
###   [<-,RangedData,ANY,ANY,ANY-method [[,RangedData-method
###   [[<-,RangedData-method show,RangedData-method
### Keywords: methods classes

### ** Examples

  ranges <- IRanges(c(1,2,3),c(4,5,6))
  filter <- c(1L, 0L, 1L)
  score <- c(10L, 2L, NA)

  ## constructing RangedData instances

  ## no variables
  rd <- RangedData()
  rd <- RangedData(ranges)
  ranges(rd)
  ## one variable
  rd <- RangedData(ranges, score)
  rd[["score"]]
  ## multiple variables
  rd <- RangedData(ranges, filter, vals = score)
  rd[["vals"]] # same as rd[["score"]] above
  rd[["filter"]]
  rd <- RangedData(ranges, score + score)
  rd[["score...score"]] # names made valid
  ## use an annotation
  rd <- RangedData(ranges, annotation = "hg18")
  annotation(rd)

  ## split some data over chromosomes

  range2 <- IRanges(start=c(15,45,20,1), end=c(15,100,80,5))
  both <- c(ranges, range2)
  score <- c(score, c(0L, 3L, NA, 22L))
  filter <- c(filter, c(0L, 1L, NA, 0L)) 
  chrom <- paste("chr", rep(c(1,2), c(length(ranges), length(range2))), sep="")

  rd <- RangedData(both, score, filter, splitter = chrom, annotation = "hg18")
  rd[["score"]] # identical to score
  rd[1][["score"]] # identical to score[1:3]

  ## subsetting

  ## list style: [i]

  rd[numeric()] # these three are all empty
  rd[logical()]
  rd[NULL]
  rd[] # missing, full instance returned
  rd[FALSE] # logical, supports recycling
  rd[c(FALSE, FALSE)] # same as above
  rd[TRUE] # like rd[]
  rd[c(TRUE, FALSE)]
  rd[1] # numeric index
  rd[c(1,2)]
  rd[-2]

  ## matrix style: [i,j]

  rd[,NULL] # no columns
  rd[NULL,] # no rows
  rd[,1]
  rd[,1:2]
  rd[,"filter"]
  rd[1,] # now by the rows
  rd[c(1,3),]
  rd[1:2, 1] # row and column
  rd[c(1:2,1,3),1] ## repeating rows

  ## variable replacement

  count <- c(1L, 0L, 2L)
  rd <- RangedData(ranges, count, splitter = c(1, 2, 1))
  ## adding a variable
  score <- c(10L, 2L, NA)
  rd[["score"]] <- score
  rd[["score"]] # same as 'score'
  ## replacing a variable
  count2 <- c(1L, 1L, 0L)
  rd[["count"]] <- count2
  ## numeric index also supported
  rd[[2]] <- score
  rd[[2]] # gets 'score'
  ## removing a variable
  rd[[2]] <- NULL
  ncol(rd) # is only 1

  ## combining/splitting

  rd <- RangedData(ranges, score, splitter = c(1, 2, 1))
  c(rd[1], rd[2]) # equal to 'rd'
  rd2 <- RangedData(ranges, score)
  unlist(split(rd2, c(1, 2, 1))) # same as 'rd'



