### Name: MaskCollection-class
### Title: MaskCollection objects
### Aliases: class:MaskCollection MaskCollection-class MaskCollection
###   nir_list nir_list,MaskCollection-method length,MaskCollection-method
###   width,MaskCollection-method active active,MaskCollection-method
###   active<- active<-,MaskCollection-method names,MaskCollection-method
###   names<-,MaskCollection-method desc desc,MaskCollection-method desc<-
###   desc<-,MaskCollection-method Mask isEmpty,MaskCollection-method
###   max,MaskCollection-method min,MaskCollection-method maskedwidth
###   maskedwidth,MaskCollection-method maskedratio
###   maskedratio,MaskCollection-method [[,MaskCollection-method
###   [[<-,MaskCollection-method [,MaskCollection,ANY,ANY,ANY-method
###   [<-,MaskCollection,ANY,ANY,ANY-method
###   append,MaskCollection,MaskCollection-method
###   reduce,MaskCollection-method gaps,MaskCollection-method
###   subseq,MaskCollection-method
###   coerce,MaskCollection,NormalIRanges-method MaskCollection.show_frame
###   show,MaskCollection-method
### Keywords: methods classes

### ** Examples

  ## Making a MaskCollection object:
  mask1 <- Mask(mask.width=29, start=c(11, 25, 28), width=c(5, 2, 2))
  mask2 <- Mask(mask.width=29, start=c(3, 10, 27), width=c(5, 8, 1))
  mask3 <- Mask(mask.width=29, start=c(7, 12), width=c(2, 4))
  mymasks <- append(append(mask1, mask2), mask3)
  mymasks
  length(mymasks)
  width(mymasks)
  reduce(mymasks)
  gaps(mymasks)

  ## Names and descriptions:
  names(mymasks) <- c("A", "B", "C")  # names should be short and unique...
  mymasks
  mymasks[c("C", "A")]  # ...to make subsetting by names easier
  desc(mymasks) <- c("you can be", "more verbose", "here")
  mymasks[-2]

  ## Activate/deactivate masks:
  active(mymasks)["B"] <- FALSE
  mymasks
  reduce(mymasks)
  active(mymasks) <- FALSE  # deactivate all masks
  mymasks
  active(mymasks)[-1] <- TRUE  # reactivate all masks except mask 1
  active(mymasks) <- !active(mymasks)  # toggle all masks

  ## Other advanced operations:
  mymasks[[2]]
  length(mymasks[[2]])
  mymasks[[2]][-3]
  append(mymasks[-2], gaps(mymasks[2]))
  mymasks2 <- subseq(mymasks, start=8)
  mymasks2
  mymasks2[[2]]



