###################################################
### chunk number 1: setSeed
###################################################
set.seed(271828)


###################################################
### chunk number 2: 
###################################################
library( HilbertVis )
vec <- makeRandomTestData( )


###################################################
### chunk number 3: 
###################################################
length(vec)


###################################################
### chunk number 4: plotLongVector
###################################################
plotLongVector( vec )


###################################################
### chunk number 5: zoomIn
###################################################
start <- 1500000
plotLongVector( vec[ start + 0:100000 ], offset=start )


###################################################
### chunk number 6: HilbertCurves
###################################################
library( grid )
pushViewport( viewport( layout=grid.layout( 2, 2 ) ) )
for( i in 1:4 ) {
   pushViewport( viewport( 
       layout.pos.row=1+(i-1)%/%2, layout.pos.col=1+(i-1)%%2 ) )
   plotHilbertCurve( i, new.page=FALSE )
   popViewport( )
}   


###################################################
### chunk number 7: 
###################################################
hMat <- hilbertImage( vec )


###################################################
### chunk number 8: HilbertTest
###################################################
image( hMat, 
   col=hilbertDefaultPalette( max(hMat), asArray=FALSE ),
   xaxt="n", yaxt="n" )


###################################################
### chunk number 9: 
###################################################
range( hMat )


###################################################
### chunk number 10:  eval=FALSE
###################################################
## img <- hilbertImage( vec, forEBImage=TRUE )
## display( img )


###################################################
### chunk number 11: 
###################################################
library( HilbertVisGUI )


###################################################
### chunk number 12:  eval=FALSE
###################################################
## hilbertDisplay( vec )


###################################################
### chunk number 13: 
###################################################
simpleLinPlot


###################################################
### chunk number 14:  eval=FALSE
###################################################
## dumpDataInsteadOfPlotting <- function( data, info ) {
##    str( data )
##    print( info )
## }
## hilbertDisplay( vec, plotFunc=dumpDataInsteadOfPlotting )


###################################################
### chunk number 15: 
###################################################
vec2 <- vec
vec2[ 7000000 : 8000000 ] <- vec[ 7010000 : 8010000 ]


###################################################
### chunk number 16:  eval=FALSE
###################################################
## hilbertDisplay( vec, vec2 )


###################################################
### chunk number 17:  eval=FALSE
###################################################
## hilbertDisplayThreeChannel( 
##    vec / max(vec), vec2 / max(vec), rep( 0, length(vec) ) )


###################################################
### chunk number 18: 
###################################################
sessionInfo()


