### Name: inbreeding
### Title: Inbreeding coefficient
### Aliases: inbreeding
### Keywords: array misc

### ** Examples

  data(Mrode2.1)
  Mrode2.1$dtB <- as.Date(Mrode2.1$dtB)
  x2.1 <- Pedigree(x=Mrode2.1, subject="sub", ascendant=c("fat", "mot"),
                   ascendantSex=c("M", "F"), family="fam", sex="sex",
                   generation="gen", dtBirth="dtB")
  fractions(inbreeding(x=x2.1))

  ## Compare the speed
  ped <- generatePedigree(nId=25)
  system.time(inbreeding(x=ped))
  # system.time(inbreeding(x=ped, method="sargolzaei")) # not yet implemented
  system.time(inbreeding(x=ped, method="tabular"))



