### Name: family
### Title: Find families (lines) in the pedigree
### Aliases: family family<-
### Keywords: misc

### ** Examples

  ## Two families examples
  ped <- data.frame(    id=c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11),
                    father=c(0, 0, 0, 0, 0, 0, 5, 1, 3,  8,  7),
                    mother=c(0, 0, 0, 0, 0, 0, 6, 2, 4,  9, 10),
                generation=c(1, 1, 1, 1, 1, 1, 2, 2, 2,  3,  4))
  ped <- Pedigree(ped, unknown=0, generation="generation")
  family(ped)

  ## After break we get two families
  ped1 <- removeIndividual(ped, individual=11)
  family(ped1)

  ## Subsetting can also be used
  family(ped[1:10,])
  family(ped[7:10,])

  ## Pedigree need not be sorted in advance
  ped2 <- ped[sample(1:10), ]
  family(ped2)

  ## Assign family values to pedigree
  family(ped) <- family(ped)
  ped
  family(ped, col="familia") <- family(ped)
  ped



