### Name: deds.stat
### Title: Differentail Expression via Distance Summary of Multiple
###   Statistics
### Aliases: deds.stat
### Keywords: htest

### ** Examples

X <- matrix(rnorm(1000,0,0.5), nc=10)
L <- rep(0:1,c(5,5))

# genes 1-10 are differentially expressed
X[1:10,6:10]<-X[1:10,6:10]+1

# DEDS summarizing t, sam and fc
deds.X <- deds.stat(X, L, B=200)

# DEDS summarizing t, tmod and fc
## Not run: 
##D deds.X <- deds.stat(X, L, testfun=list(t=comp.t(L),
##D tmod=comp.modt(L), sam=comp.SAM(L)))
## End(Not run)

# one can also use:
## Not run: 
##D deds.X <- deds.stat(X, L, testfun=deds.chooseTest(L,
##D tests=c("t","modt","fc")))
## End(Not run)




