### Name: comp.SAM
### Title: Computing SAM Statistics for Differential Expression
### Aliases: comp.SAM
### Keywords: univar

### ** Examples

X <- matrix(rnorm(1000,0,0.5), nc=10)
L <- rep(0:1,c(5,5))

# genes 1-10 are differentially expressed
X[1:10,6:10]<-X[1:10,6:10]+1

# two sample test, statistics only
sam.fun <- comp.SAM(L)
sam.X <- sam.fun(X)

# two sample test, FDR
sam.fun <- comp.SAM(L, stat.only=FALSE, delta=c(0.1, 0.2, 0.5))
sam.X <- sam.fun(X)




