### Name: stringDist
### Title: String Distance/Alignment Score Matrix
### Aliases: stringDist stringDist,character-method
###   stringDist,XStringSet-method
###   stringDist,QualityScaledXStringSet-method
### Keywords: character multivariate cluster

### ** Examples

  stringDist(c("lazy", "HaZy", "crAzY"))
  stringDist(c("lazy", "HaZy", "crAzY"), ignoreCase = TRUE)

  data(phiX174Phage)
  plot(hclust(stringDist(phiX174Phage), method = "single"))

  data(srPhiX174)
  stringDist(srPhiX174[1:4])
  stringDist(srPhiX174[1:4], method = "quality",
             quality = SolexaQuality(quPhiX174[1:4]),
             gapOpening = -10, gapExtension = -4)



