### Name: readFASTA
### Title: Functions to read/write FASTA formatted files
### Aliases: fasta.info readFASTA writeFASTA
### Keywords: utilities manip

### ** Examples

  f1 <- system.file("extdata", "someORF.fa", package="Biostrings")
  file.info(f1)
  ff <- readFASTA(f1, strip.descs=TRUE)
  desc <- sapply(ff, function(x) x$desc)
  ## Keep the "reverse complement" sequences only
  ff2 <- ff[grep("reverse complement", desc, fixed=TRUE)]
  writeFASTA(ff2, file.path(tempdir(), "someORF2.fa"))



