### Name: match-utils
### Title: Utility functions related to pattern matching
### Aliases: match-utils neditStartingAt neditEndingAt neditAt
###   isMatchingStartingAt isMatchingEndingAt isMatchingAt
###   neditStartingAt,character-method neditStartingAt,XString-method
###   neditEndingAt,character-method neditEndingAt,XString-method
###   isMatchingStartingAt,character-method
###   isMatchingStartingAt,XString-method
###   isMatchingEndingAt,character-method isMatchingEndingAt,XString-method
###   mismatch mismatch,ANY,XStringViews-method nmatch
###   nmatch,ANY,XStringViews-method nmismatch
###   nmismatch,ANY,XStringViews-method coverage,XStringViews-method
###   coverage,MaskedXString-method coverage,MIndex-method
###   nmismatchStartingAt nmismatchEndingAt isMatching
### Keywords: methods

### ** Examples

  ## ---------------------------------------------------------------------
  ## neditAt() / isMatchingAt()
  ## ---------------------------------------------------------------------
  subject <- DNAString("GTATA")

  ## Pattern "AT" matches subject "GTATA" at position 3 (exact match)
  neditAt("AT", subject, at=3)
  isMatchingAt("AT", subject, at=3)

  ## ... but not at position 1
  neditAt("AT", subject)
  isMatchingAt("AT", subject)

  ## ... unless we allow 1 mismatching letter (inexact match)
  isMatchingAt("AT", subject, max.mismatch=1)

  ## Here we look at 6 different starting positions and find 3 matches if
  ## we allow 1 mismatching letter
  isMatchingAt("AT", subject, at=0:5, max.mismatch=1)

  ## No match
  neditAt("NT", subject, at=1:4)
  isMatchingAt("NT", subject, at=1:4)

  ## 2 matches if N is interpreted as an ambiguity (fixed=FALSE)
  neditAt("NT", subject, at=1:4, fixed=FALSE)
  isMatchingAt("NT", subject, at=1:4, fixed=FALSE)

  ## max.mismatch != 0 and fixed=FALSE can be used together
  neditAt("NCA", subject, at=0:5, fixed=FALSE)
  isMatchingAt("NCA", subject, at=0:5, max.mismatch=1, fixed=FALSE)

  some_starts <- c(10:-10, NA, 6)
  subject <- DNAString("ACGTGCA")
  is_matching <- isMatchingAt("CAT", subject, at=some_starts, max.mismatch=1)
  some_starts[is_matching]

  ## ---------------------------------------------------------------------
  ## mismatch() / nmismatch()
  ## ---------------------------------------------------------------------
  m <- matchPattern("NCA", subject, max.mismatch=1, fixed=FALSE)
  mismatch("NCA", m)
  nmismatch("NCA", m)

  ## ---------------------------------------------------------------------
  ## coverage()
  ## ---------------------------------------------------------------------
  coverage(m)

  ## See ?matchPDict for examples of using coverage() on an MIndex object...



