### Name: MaskedXString-class
### Title: MaskedXString objects
### Aliases: class:MaskedXString MaskedXString-class MaskedXString
###   class:MaskedBString MaskedBString-class MaskedBString
###   class:MaskedDNAString MaskedDNAString-class MaskedDNAString
###   class:MaskedRNAString MaskedRNAString-class MaskedRNAString
###   class:MaskedAAString MaskedAAString-class MaskedAAString unmasked
###   unmasked,MaskedXString-method masks masks,XString-method
###   masks,MaskedXString-method alphabet,MaskedXString-method
###   length,MaskedXString-method maskedwidth,MaskedXString-method
###   maskedratio,MaskedXString-method nchar,MaskedXString-method
###   coerce,BString,MaskedBString-method
###   coerce,DNAString,MaskedDNAString-method
###   coerce,RNAString,MaskedRNAString-method
###   coerce,AAString,MaskedAAString-method
###   coerce,MaskedBString,BString-method
###   coerce,MaskedDNAString,DNAString-method
###   coerce,MaskedRNAString,RNAString-method
###   coerce,MaskedAAString,AAString-method XString,MaskedXString-method
###   coerce,MaskedXString,MaskCollection-method
###   coerce,MaskedXString,NormalIRanges-method
###   coerce,MaskedXString,XStringViews-method reduce,MaskedXString-method
###   gaps,MaskedXString-method subseq,MaskedXString-method
###   as.character,MaskedXString-method toString,MaskedXString-method
###   show,MaskedXString-method masks<- masks<-,MaskedXString,NULL-method
###   masks<-,MaskedXString,MaskCollection-method
###   masks<-,XString,NULL-method masks<-,XString,ANY-method
###   Views,MaskedXString-method
### Keywords: methods classes

### ** Examples

  ## ---------------------------------------------------------------------
  ## A. MASKING BY POSITION
  ## ---------------------------------------------------------------------
  mask0 <- Mask(mask.width=29, start=c(3, 10, 25), width=c(6, 8, 5))
  x <- DNAString("ACACAACTAGATAGNACTNNGAGAGACGC")
  length(x)  # same as width(mask0)
  nchar(x)   # same as length(x)
  masks(x) <- mask0
  x
  length(x)  # has not changed
  nchar(x)   # has changed
  gaps(x)

  ## Prepare a MaskCollection object of 3 masks ('mymasks') by running the
  ## examples in the man page for these objects:
  example(MaskCollection, package="IRanges")

  ## Put it on 'x':
  masks(x) <- mymasks
  x
  alphabetFrequency(x)

  ## Deactivate all masks:
  active(masks(x)) <- FALSE
  x

  ## Activate mask "C":
  active(masks(x))["C"] <- TRUE
  x

  ## Turn MaskedXString object into an XStringViews object:
  as(x, "XStringViews")

  ## Drop the masks:
  masks(x) <- NULL
  x
  alphabetFrequency(x)

  ## ---------------------------------------------------------------------
  ## B. MASKING BY CONTENT
  ## ---------------------------------------------------------------------
  ## See ?maskMotif for masking by content



