### Name: nullDistDoublyTestedEdges
### Title: Null distribution of number of reciprocated, unreciprocated and
###   missing edges in stochastic model.
### Aliases: nullDistDoublyTestedEdges
### Keywords: manip

### ** Examples

p = nullDistDoublyTestedEdges(32, 1000, pFP=0.001, pFN=0.15)

if(interactive() && require("RColorBrewer"))
  for(k in 1:dim(p)[3]) {
    image(sqrt(p[,,k]), xlab=expression(N[rec]), ylab=expression(N[unrec]),
        main = expression(P(N[rec], N[unrec]~";"~ delta^"*", n, p[FP], p[FN])),
        x = 1:dim(p)[1], y = 1:dim(p)[2], 
        col = colorRampPalette(brewer.pal(9, "GnBu"))(256))
    text(35, 35, paste("delta", k, sep="="))
  }



