### Name: symbolsInteresting
### Title: Useful for changing the look of pairs plots to emphasize
###   concordant or discordant genes
### Aliases: symbolsInteresting
### Keywords: dplot

### ** Examples


  data(expressionSetList)
  data(xmcmc)
  bes <- bayesianEffectSize(xmcmc)
  postAvg <- posteriorAvg(xmcmc)
  op.conc <- symbolsInteresting(rankingStatistic=postAvg[, "concordant"])
  graphics:::pairs(bes[op.conc$order, ], pch=op.conc$pch, col=op.conc$col, 
                   bg=op.conc$bg, upper.panel=NULL, cex=op.conc$cex)  




