###################################################
### chunk number 1: loadlib
###################################################
library("EBImage")


###################################################
### chunk number 2: example.choose.image eval=FALSE
###################################################
## x = chooseImage(TrueColor)


###################################################
### chunk number 3: example.read.image
###################################################
imgdir = file.path(system.file(package="EBImage"), "images")
fG = dir(imgdir, pattern="_G.tif", full.names=TRUE)
iG = readImage(fG[1], Grayscale)
class(iG)
dim(iG)

fR = dir(imgdir, pattern="_R.tif", full.names=TRUE)
iR = readImage(fR[1])


###################################################
### chunk number 4: example.readRemote eval=FALSE
###################################################
## baseurl = "http://www.ebi.ac.uk/~osklyar/BioC2007/data"
## a = readImage(paste(baseurl, c("Gene1_R.tif", "Gene2_R.tif"), sep="/"))


###################################################
### chunk number 5: writeImage
###################################################
outdir = tempdir()
writeImage(iR, file.path(outdir, "test.png"))
compression(iR)
writeImage(iR[,,1], file.path(outdir, "test.jpg"), quality=90)
file.info(dir(outdir, full.names=TRUE))[,c(1,5)]


###################################################
### chunk number 6: example.imageDisplay1 eval=FALSE
###################################################
## display(iR)
## animate(iR)


###################################################
### chunk number 7: example.imageDisplay2 eval=FALSE
###################################################
## image(iR[,,1])


###################################################
### chunk number 8: isArray
###################################################
is(iG, "array")


###################################################
### chunk number 9: isArrayCheck
###################################################
stopifnot(is(iG, "array"))


###################################################
### chunk number 10: hists
###################################################
par(mfrow=c(2,2))
for(i in 1:4) 
  hist(iR[,,i], breaks=20, xlim=c(0,1))


###################################################
### chunk number 11: example.print.methods
###################################################
dim(iR)
range(iR)
print(iR)
str(iR)


###################################################
### chunk number 12: example.normalizations
###################################################
iRnns = normalize(iR, separate=FALSE)
apply(iRnns, 3, range)
iRn = normalize(iR, separate=TRUE)
apply(iRn, 3, range)
iGn = normalize(iG, separate=TRUE)


###################################################
### chunk number 13: example.modifFunctions
###################################################
modif1 = function(x) sin((x-1.2)^3)+1
modif2 = function(x, s) (exp(-s*x) - 1) / (exp(-s) - 1)
modif3 = function(x) x^0.5


###################################################
### chunk number 14: functions
###################################################
x = (0:100)/100
plot(x, x, type="l", xlim=c(0,1), ylim=c(0,1), col="gray", lwd=1, lty=2,
     xlab="source intensity", ylab="target intensity")
lines(x, modif2(x,4), col="#10508B", lwd=2)
text(0.3, 0.83, "modif2(s=4)", col="#10508B")
lines(x, modif2(x,-4), col="#4E82B5", lwd=2)
text(0.7, 0.16, "modif2(s=-4)", col="#4E82B5")
lines(x, sqrt(x), col="#24A072", lwd=2)
text(0.2, 0.37, "sqrt")
lines(x, x^1.5, col="#421C80", lwd=2)
text(0.52, 0.3, "modif3", col="#421C80")
lines(x, modif1(x), col="red", lwd=2)
text(0.52, 0.6, "modif1", col="red")


###################################################
### chunk number 15: example.resize
###################################################
a1 = resize(iRn, dim(iRn)[1]*1.3)
a2 = rotate(iRn, 15)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## display(a1)
## display(a2)


###################################################
### chunk number 17: example.grayscaleToRGB
###################################################
iRG = channel(iRn, "asred") + channel(iGn, "asgreen")


###################################################
### chunk number 18: example.displayConversions eval=FALSE
###################################################
## display(iRG)
## display(channel(iRG, "gray"))
## display(channel(iRG, "asred"))


###################################################
### chunk number 19: write.iRG
###################################################
writeImage(iRG[,,1], "iRG.png")


###################################################
### chunk number 20: example.channel1
###################################################
ch = channel(c(0.2, 0.5), "rgb") 
ch
sprintf("%X", ch)


###################################################
### chunk number 21: example.channel2
###################################################
channel(c(0.2, 0.5), "x11") 


###################################################
### chunk number 22: example.channel3
###################################################
channel(c("red","green","#0000FF"), "rgb") 


###################################################
### chunk number 23: example.channel4
###################################################
channel(as.integer(c(0x0000f0, 0x00f000, 0xf0000, 0x808080)), "gray") 


###################################################
### chunk number 24: example.runif.Image
###################################################
a = Image(runif(200*100), c(200,100))


###################################################
### chunk number 25: 
###################################################
writeImage(a, "AnalysisWithEBImage-random.png")


###################################################
### chunk number 26: example.masking
###################################################
a = iRn
a[ a > 0.6 ] = 1.0
a[ a <= 0.6] = 0.0


###################################################
### chunk number 27: example.colorMask
###################################################
b = channel(a, "rgb")
b[ a >= 0.1] = channel("red", "rgb")
b[ a < 0.1 ] = channel("#114D90", "rgb")


###################################################
### chunk number 28:  eval=FALSE
###################################################
## display(b)


###################################################
### chunk number 29: 
###################################################
writeImage(b[,,1], "06.png")
rm(a,b,x)
gc()


###################################################
### chunk number 30: example.threshG
###################################################
mask = thresh(iGn, 15, 15, 0.002)


###################################################
### chunk number 31: 
###################################################
writeImage(mask[,,1], "07.png")


###################################################
### chunk number 32: example.dilate
###################################################
mk3 = morphKern(3)
mk5 = morphKern(5)
mask = dilate(erode(closing(mask, mk5), mk3), mk5)


###################################################
### chunk number 33: 
###################################################
writeImage(mask[,,1], "08.png")


###################################################
### chunk number 34: example.watershedOnDistmap
###################################################
sG = watershed( distmap(mask), 1.5, 1)


###################################################
### chunk number 35: 
###################################################
writeImage(normalize(sG[,,1]), "09.png")


###################################################
### chunk number 36: example.removeBadG
###################################################
ft = hullFeatures(sG)  ## need these for edge and perimeter
mf = moments(sG, iGn)   ## need these for intensity and size
for ( i in seq_along(ft) ) ft[[i]] = cbind(ft[[i]], mf[[i]])
sG = rmObjects(sG, 
        lapply(ft, 
          function(x) 
            which(x[,"h.s"] < 150 | x[,"h.s"] > 10000 | x[,"int"] < 30 |
                  0.4 * x[,"h.p"] < x[,"h.edge"] )
      ))


###################################################
### chunk number 37: 
###################################################
writeImage(normalize(sG[,,1]), "10.png")


###################################################
### chunk number 38: example.propagate
###################################################
mask = thresh(blur(iRn,4,1.5), 25, 25, 0.005)
mask = erode( erode( dilate(mask,mk5), mk5), mk3 )
sR = propagate( iRn, sG, mask, 1e-5, 1.6)


###################################################
### chunk number 39: 
###################################################
writeImage(normalize(sR[,,1]), "11.png")


###################################################
### chunk number 40: example.matching
###################################################
for ( i in 1:dim(sR)[3] ) {
  x = sG[,,i]
  x[ x > max(sR[,,i]) ] = 0.0
  sG[,,i] = x
}


###################################################
### chunk number 41: example.removeBadR
###################################################
ft = hullFeatures(sR)
mf = moments(sR, iRn)
for ( i in seq_along(ft) ) ft[[i]] = cbind(ft[[i]], mf[[i]])
index = lapply(ft, 
           function(x) 
             which( x[,"h.s"] < 150 | x[,"h.s"] > 15000 | 
                    x[,"int"]/x[,"h.s"] < 0.1 | 
                    0.3 * x[,"h.p"] < x[,"h.edge"]
         ))
sR = rmObjects(sR, index)
sG = rmObjects(sG, index)


###################################################
### chunk number 42: 
###################################################
writeImage(normalize(sR[,,1]), "12.png")


###################################################
### chunk number 43: example.getFeatures
###################################################
sG = getFeatures(sG, iGn)
sR = getFeatures(sR, iRn)
nucl = do.call("rbind", features(sG))
cells = do.call("rbind", features(sR))
stopifnot(identical(dim(nucl), dim(cells)))


###################################################
### chunk number 44: example.visualize
###################################################
rgb = paintObjects(sR, iRG)
rgb = paintObjects(sG, rgb)

ct = tile(stackObjects(sR, iRn))
nt = tile(stackObjects(sG, iGn))


###################################################
### chunk number 45: 
###################################################
writeImage(rgb[,,1], "13.png")


