### Name: selSpots
### Title: Select spots to use in normalisation
### Aliases: selSpots
### Keywords: classes

### ** Examples

## Loading the dataset
data(gastro)

## Filtering all spots with signal2noise ratio (Sf/Sb or Rf/Rb) greater
## or equal to 1 and that have 'Name' label as 'BLANK', 'DAP', ..., 'TRP'.
gastro.raw2 = selSpots(gastro.raw, sigNoise=1, rmFlag=NULL, gLabelsID="Name",
  remove=list(c("BLANK","DAP","LYS","PHE","Q_GENE","THR","TRP")))

## To see the number of spots that suvived the filtering above do
apply(gastro.raw2@UseSpots, 2, sum)

## To do the same filtering as above, also filtering flags marcke as 1
## and 4 do
gastro.raw2 = selSpots(gastro.raw, sigNoise=1, rmFlag=c(1,4), gLabelsID="Name",
  remove=list(c("BLANK","DAP","LYS","PHE","Q_GENE","THR","TRP")))

apply(gastro.raw2@UseSpots, 2, sum)



