### Name: plotGenePair
### Title: Scatter plots for pair of genes
### Aliases: plotGenePair
### Keywords: classes

### ** Examples

## Loading the dataset
data(gastro)

## Constructing the relevance network for sample
## 'Tissue' comparing 'Neso' and 'Aeso' for the 1st gene group
gastro.net = relNetworkM(gastro.summ, sLabelID="Tissue", 
  samples = list(Neso="Neso", Aeso="Aeso"), geneGrp=11,
  type="Rpearson")

## As the sample size is small, because we used a small fraction of the
## genes from the original dataset, this isn't so reliable.
plotGenePair(gastro.net, "KLK13", "EVPL")



