### Name: samrocNboot
### Title: Calculate ROC curve based SAM statistic
### Aliases: samrocNboot
### Keywords: htest

### ** Examples

library(multtest)
#Loading required package: genefilter 
#Loading required package: survival 
#Loading required package: splines 
#Loading required package: reposTools 
data(golub)
 # This makes the expression data from Golub et al available
 # in the matrix golub, and the sample labels in the vector golub.cl
set.seed(849867)
samroc.res <- samrocNboot(data = golub, formula = ~as.factor(golub.cl))
# The proportion of unchanged genes is estimated at
samroc.res@p0
# The fudge factor equals
 samroc.res$s0
# A histogram of p-values
 hist(samroc.res@pvalues)
 # many genes appear changed



