### Name: findPeaksOnSmoothed
### Title: Find peaks on smoothed ExpressionSet
### Aliases: findPeaksOnSmoothed
### Keywords: manip

### ** Examples

  exDir <- system.file("exData",package="Ringo")
  load(file.path(exDir,"exampleProbeAnno.rda"))
  load(file.path(exDir,"exampleX.rda"))
  smoothX <- computeRunningMedians(exampleX, probeAnno=exProbeAnno,
       modColumn = "Cy5", allChr = "9", winHalfSize = 400)
  peaksX <- findPeaksOnSmoothed(smoothX, probeAnno=exProbeAnno,
       thresholds=0.45, allChr="9", distCutOff=600, cellType="human")
  if (interactive())
    plot(peaksX[[1]], smoothX, probeAnno=exProbeAnno, gff=exGFF)
  peaksX <- relatePeaks(peaksX, exGFF)
  as.data.frame.peakList(peaksX)



