### Name: select.sig.gene
### Title: select differentially expressed genes based on p value and/or
###   fold change
### Aliases: select.sig.gene
### Keywords: misc

### ** Examples

data(testData)
normaldata<-pre.process("rma",testData)
## Create design matrix
design<-make.design(pData(normaldata), "group")

## Create contrast matrix - Compare group "A" vs. "C"
contrast<-make.contrast(design, "A", "C")

## Identify differentially expressed gene by using LIMMA method
result<-regress(normaldata, design, contrast, "L")

## Select differentially expressed gene based on p <0.05 and 
## fold change >=log2(1.5)
select<-select.sig.gene(result, p.value=0.05, m.value=log2(1.5))




