### Name: KS.flowcytest
### Title: Kolmogorov Smirnoff Test 2-sample
### Aliases: KS.flowcytest KS
### Keywords: dplot distribution

### ** Examples

 
    ## different distributions
    control<-rnorm(1000, mean=3, sd=.7)
    stimulated<-rnorm(1000, mean=2, sd=.5)

    if (interactive()==TRUE) {
      output.same <- KS.flowcytest(control, stimulated,
                                   title="Different Distributions",
                                   varname="Interferon Gamma",
                                   yupper=1, xlimit=c(-5,8))
    }
    ## same distribution
    stimulated2<-rnorm(1000, mean=3, sd=.7)
    if (interactive()==TRUE) {
      output.diff <- KS.flowcytest(control, stimulated2,
                                   title="Same Distributions",
                                   varname="Interferon Gamma",
                                   yupper=1, xlimit=c(-5,8))
    }

    ## obtaining the FCS objects from VRC data
    if (require(rfcdmin)) {
      data.there<-is.element(c("st.1829", "unst.1829", "st.DRT", "unst.DRT"),objects())
      if ((sum(data.there) != length(data.there))) {
        ## obtaining the FCS objects from VRC data
        data(VRCmin)
      }

      ## This only serves as an example.  Usually the FCS object is
      ## gated and then subset

      ## HIV negative individual 1829
      ## only the first 2000 cells are selected

      IFN.control<-unst.1829@data[1:2000,4]
      IFN.stimul<-st.1829@data[1:2000,4]
     
      if (interactive()==TRUE){
        KS.flowcytest(IFN.control, IFN.stimul,
          title="HIV Negative Individual 1829", varname="Interferon Gamma",
          yupper=.006)
      }
      ## HIV positive individual DRT
      ## only the first 2000 cells are selected

      IFN.control2<-unst.DRT@data[1:2000,4]
      IFN.stimul2<-st.DRT@data[1:2000,4]
      
      if (interactive()){

      KS.flowcytest(IFN.control2, IFN.stimul2,
            title="HIV Positive Individual DRT", varname="Interferon Gamma",
            yupper=.006)
    }
    ## This is an artifical example, but one would expect the
    ## distributions of the stimulated and control samples
    ## to be the same in the HIV negative individual 1829
    ## and to be different in the HIV positive individual DRT
    ## The test in this example is a bit contrived but
    ## the bigger picture is achieved.
  }
  



