### Name: calculateFC
### Title: Calculate differential expression between conditions using FC
### Aliases: calculateFC
### Keywords: manip

### ** Examples

        library(puma)
        data(affybatch.example)
        pData(affybatch.example) <- data.frame("level"=c("twenty","twenty","ten")
            , "batch"=c("A","B","A"), row.names=rownames(pData(affybatch.example)))
        eset_rma <- rma(affybatch.example)
        FCRes <- calculateFC(eset_rma)
        topGeneIDs(FCRes,numberOfGenes=6)
        plotErrorBars(eset_rma, topGenes(FCRes))



