### Name: cytoSet-class
### Title: 'cytoSet': a class for storing raw data from a quantitative
###   cell-based assay
### Aliases: cytoSet cytoSet-class [,cytoSet,ANY,missing,missing-method
###   [[,cytoSet,ANY,missing-method [[<-,cytoSet-method show,cytoSet-method
###   length,cytoSet-method pData,cytoSet-method colnames,cytoSet-method
###   colnames<-,cytoSet-method phenoData,cytoSet-method
###   phenoData<-,cytoSet,AnnotatedDataFrame-method
###   plot,cytoSet,missing-method hist,cytoSet-method
###   split,cytoSet,ANY,ANY-method
### Keywords: classes

### ** Examples

cset<-readCytoSet(path=system.file("extdata", package="prada"),
  pattern="[A-Z][0-9][0-9]$")
cset
pData(cset)
cset[[1]]
cset[["fas-Bcl2-plate323-04-04.A02"]]
cset["fas-Bcl2-plate323-04-04.A02"]
cset[1:3]

cset[[1]] <- exprs(cset[[1]])[1:100, ]

## Not run: 
##D plot(cset[2])
## End(Not run)




