### Name: sumstats
### Title: Summary statistics on xy co-ordinates, returns the slopes and
###   distance from origin of each co-ordinate.
### Aliases: sumstats
### Keywords: manip

### ** Examples

data(khan)

if (require(ade4, quiet = TRUE)) {

khan.bga<-bga(khan$train, khan$train.classes)}

s.var(khan.bga$bet$ls, col=as.numeric(khan$train.classes), clabel=0.8)
st.out<-sumstats(khan.bga$bet$ls)

# Get stats on classes  EWS and BL
EWS<-khan$train.classes==levels(khan$train.classes)[1]
st.out[EWS,]

BL<-khan$train.classes==levels(khan$train.classes)[2]
st.out[BL,]

# Add dashed line to plot to highlight min and max slopes of class BL
slope.BL.min<-min(st.out[BL,1])
slope.BL.max<-max(st.out[BL,1])
abline(c(0,slope.BL.min), col="red", lty=5)
abline(c(0,slope.BL.max), col="red", lty=5)




