### Name: AgTextLabel-class
### Title: Class "AgTextLabel": Represents a graphviz text label
### Aliases: AgTextLabel-class labelText labelLoc labelJust labelWidth
###   labelColor labelFontsize labelFontsize,AgTextLabel-method
###   labelColor,AgTextLabel-method labelText,AgTextLabel-method
###   labelLoc,AgTextLabel-method labelJust,AgTextLabel-method
###   labelWidth,AgTextLabel-method drawTxtLabel
### Keywords: classes

### ** Examples

V <- letters[1:10]
M <- 1:4
g1 <- randomGraph(V, M, .2)

## Make the labels be the edge weights.  This code is from the vignette
eAttrs <- list()
ew <- edgeWeights(g1)
lw <- unlist(unlist(ew))
toRemove <- removedEdges(g1)
lw <- lw[-toRemove]
names(lw) <- edgeNames(g1)
eAttrs$label <- lw

z <- agopen(g1,"foo", edgeAttrs=eAttrs)
x <- AgEdge(z)  ## list of AgEdge objects
x[[1]]  ## AgEdge
a <- txtLabel(x[[1]])
a ## txtLabel object

labelText(a)
labelLoc(a)
labelJust(a)
labelWidth(a)
labelColor(a)
labelFontsize(a)



