### Name: genome.plot
### Title: Display a pan-genomic representation of a normalized arrayCGH
### Aliases: genome.plot genome.plot.default genome.plot.arrayCGH


### ** Examples

data(spatial)

## default color code: log-ratios
## Not run: 
##D genome.plot(edge.norm, chrLim="LimitChr")
## End(Not run)

## color code determined by a qualitative variable: ZoneGNL (DNA copy number code)
edge.norm$cloneValues$ZoneGNL <- as.factor(edge.norm$cloneValues$ZoneGNL)
## Not run: 
##D genome.plot(edge.norm, col.var="ZoneGNL")
## End(Not run)
## comparing profiles with and without normalization
## aggregate data without normalization (flags)

gradient.nonorm <- norm.arrayCGH(gradient, flag.list=NULL, var="LogRatio",
FUN=median, na.rm=TRUE)
gradient.nonorm <- sort.arrayCGH(gradient.nonorm)

## Not run: 
##D genome.plot(gradient.nonorm, pch=20, main="Genomic profile without
##D normalization", chrLim="LimitChr")   
##D x11()
##D genome.plot(gradient.norm, pch=20, main="Genomic profile with
##D normalization", chrLim="LimitChr")   
## End(Not run)



