haplo.score.w          package:GeneticsBase          R Documentation

_W_r_a_p_p_e_r _f_o_r _c_o_m_p_u_t_i_n_g _s_c_o_r_e _s_t_a_t_i_s_t_i_c_s _t_o _e_v_a_l_u_a_t_e _t_h_e _a_s_s_o_c_i_a_t_i_o_n _o_f _a _t_r_a_i_t _w_i_t_h _h_a_p_l_o_t_y_p_e_s, _w_h_e_n _l_i_n_k_a_g_e _p_h_a_s_e _i_s _u_n_k_n_o_w_n _a_n_d _d_i_p_l_o_i_d _m_a_r_k_e_r _p_h_e_n_o_t_y_p_e_s _a_r_e _o_b_s_e_r_v_e_d _a_m_o_n_g _u_n_r_e_l_a_t_e_d _s_u_b_j_e_c_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     wrapper for computing score statistics to evaluate the association
     of a trait with haplotypes, when linkage phase is unknown and
     diploid marker phenotypes are observed among unrelated subjects.
     For now, only autosomal loci are considered.

_U_s_a_g_e:

     haplo.score.w(geneSetObj, 
                   trait.type = "gaussian", 
                   offset = NA, 
                   x.adj = NA, 
                   skip.haplo = 5/(2 * nrow(geno)), 
                   locus.label = NA, 
                   miss.val = c(0, NA), 
                   simulate = FALSE, 
                   sim.control = score.sim.control(), 
                   em.control = haplo.em.control())

_A_r_g_u_m_e_n_t_s:

geneSetObj: A geneSet object

trait.type: Character string defining type of trait, with values of
          "gaussian", "binomial", "poisson", "ordinal".

  offset: Vector of offset when trait.type = "poisson" 

   x.adj: Matrix of non-genetic covariates used to adjust the score
          statistics.  Note that intercept should not be included,  as
          it will be added in this function. 

skip.haplo: Skip score statistics for haplotypes with frequencies <
          'skip.haplo'. The default is for an expected count of 5 out
          of the 2*N haplotype  occurrences.

locus.label: Vector of labels for loci. 

miss.val: vector of values that represent missing alleles in geno.

simulate: Logical:  if [F]alse, no empirical p-values are computed; if
          [T]rue, simulations are performed. Specific simulation
          parameters can be controlled in the sim.control parameter
          list. 

sim.control: List of control parameters to determine how simulations
          are performed for simulated p-values. The list is created by
          the function 'score.sim.control' and the default values of
          this function can be changed as desired. See
          'score.sim.control' for details.

em.control: A list of control parameters to determine how to perform
          the EM algorithm for estimating haplotype frequencies when
          phase is   unknown. The list is created by the function
          'haplo.em.control' - see this function for more details

_D_e_t_a_i_l_s:

     Please refer to 'haplo.score' for more details.

_V_a_l_u_e:

     List with the following components:

score.global: Global statistic to test association of trait with 
          haplotypes that have frequencies >= skip.haplo. 

      df: Degrees of freedom for score.global. 

score.global.p: P-value of score.global based on chi-square
          distribution,  with degrees of freedom equal to df. 

score.global.p.sim: P-value of score.global based on simulations (set
          equal to NA when simulate=F). 

score.haplo: Vector of score statistics for individual haplotypes that
          have frequencies >= skip.haplo. 

score.haplo.p: Vector of p-values for score.haplo, based on a
          chi-square distribution with 1 df. 

score.haplo.p.sim: Vector of p-values for score.haplo, based on
          simulations (set equal to NA when simulate=F). 

score.max.p.sim: Simulated p-value indicating for simulations the
          number of times a  maximum score.haplo value exceeds the
          maximum score.haplo from the original data (equal to NA when
          simulate=F). 

haplotype: Matrix of hapoltypes  analyzed.  The ith row of haplotype
          corresponds to the ith item of score.haplo, score.haplo.p,
          and score.haplo.p.sim. 

hap.prob: Vector of haplotype probabilies, corresponding to the
          haplotypes in the matrix haplotype. 

locus.label: Vector of labels for loci, of length  K  (same  as input
          argument). 

simulate: Same as function input parameter.  If [T]rue, simulation
          results are included in the haplo.score object. 

n.val.global: Vector containing the number of valid simulations used in
          the global score statistic simulation. The number of valid
          simulations can be less than the number of simulations
          requested (by sim.control) if simulated data sets produce
          unstable variances of the score statistics.   

n.val.haplo: Vector containing the number of valid simulations used in
          the p-value simulations for maximum-score statistic and
          scores for the individual haplotypes. 

_N_o_t_e:

     ~~further notes~~

_A_u_t_h_o_r(_s):

_R_e_f_e_r_e_n_c_e_s:

     ~put references to the literature/web site here ~

_S_e_e _A_l_s_o:

     'haplo.em.w', 'haplo.scan.w', 'haplo.score.slide.w'

_E_x_a_m_p_l_e_s:

     ##---- Should be DIRECTLY executable !! ----
     ##-- ==>  Define data, use random,
     ##--    or do  help(data=index)  for the standard data sets.

     ## The function is currently defined as
     "haplo.score.w"

